package gov.va.genisis2.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.dao.impl.RequestDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.WorkflowStatus;
import gov.va.genisis2.service.IRequestService;

/**
 * The Class RequestServiceTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class RequestServiceTest.
 * 
 *         Description: In this RequestServiceTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class RequestServiceTest extends AbstractMockMvcTests {

	/** The LOGGER. */
	private static final Logger logger = LoggerFactory.getLogger(RequestServiceTest.class);

	@Autowired
	private IRequestService requestService;

	@Autowired
	private IRequestDao requestDao;

	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	private Request request;

	private RequestService requestService_SF_NULL;

	private RequestDao requestDao_SF_Null;

	/**
	 * Test create request null.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testCreateRequest_null1() throws GenisisServiceException {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");
		assertEquals(0, requestService.createRequest(null));

	}

	/**
	 * Test create request null.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testCreateRequest_null2() throws GenisisServiceException {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");
		requestService.createRequest(new Request());

	}

	/**
	 * To test create request.
	 * 
	 * @throws GenisisDAOException
	 * @throws GenisisServiceException
	 */
	@Test
	public void testCreateRequest_notNull() throws GenisisDAOException, GenisisServiceException {
		// testing when request are not null
		logger.info("**********Junit Test Create Request Not Null**********");

		request = requestDao.getRequestById(1);
		assertNotEquals(0, requestService.createRequest(request));

	}

	/**
	 * Test create request null.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testCreateRequest_null() throws GenisisServiceException {
		// testing when request is null
		logger.info("**********Junit Test Create Request Null**********");
		setSessionFactory_Null();
		requestService_SF_NULL.createRequest(new Request());

	}

	/**
	 * Test get requests by UID.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestsByUID() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests by uid **********");
		List<Request> requests = requestService.getRequestsByUID("researcher1");
		assertNotNull(requests);

	}

	/**
	 * Test get requests by UID.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestsByUID_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests by uid **********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestsByUID("researcher1");

	}

	/**
	 * Test get requests data manager.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestsDataManagers() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests Data Manager**********");

		List<Request> requests = requestService.getRequestsDataManagers("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get requests data manager.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestsDataManagers_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests Data Manager**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestsDataManagers("researcher1");
	}

	/**
	 * Test get requests by data manager.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestsByDataManagers() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests By Data Manager**********");

		List<Request> requests = requestService.getRequestsByDataManagers("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get requests by data manager.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestsByDataManagers_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests By Data Manager**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestsByDataManagers("researcher1");
	}

	/**
	 * Test get Requests Data Source Managers
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestsDataSourceManagers() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests DataSource Managers**********");

		List<Request> requests = requestService.getRequestsDataSourceManagers("researcher1");
		assertNotNull(requests);
	}

	/**
	 * Test get Requests Data Source Managers
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestsDataSourceManagers_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests DataSource Managers**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestsDataSourceManagers("researcher1");

	}

	/**
	 * Test get Request By Id
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestsById() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests By Id**********");

		Request requests = requestService.getRequestById(1);
		assertEquals(1, requests.getId());
	}

	@Test(expected = GenisisServiceException.class)
	public void testGetRequestsById_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get Requests By Id**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestById(1);
	}

	/**
	 * Test get All Requests.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetAllRequests() throws GenisisServiceException {

		logger.info("**********Junit Test Get All Requests**********");

		List<Request> requests = requestService.getAllRequests();
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetAllRequests_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get All Requests**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getAllRequests();
	}

	/**
	 * Test get All Requests By Study Approval.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetAllRequestsByStudyApproval() throws GenisisDAOException, GenisisServiceException {

		logger.info("**********Junit Test Get All Requests By Study Approval**********");
		StudyApproval studyApproval = studyApprovalDao.getStudyApprovalsByID(176);
		List<Request> requests = requestService.getAllRequestsByStudyApproval(studyApproval.getId());
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests By Study Approval.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetAllRequestsByStudyApproval_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get All Requests By Study Approval**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getAllRequestsByStudyApproval(1);
	}

	/**
	 * Test get All Requests By Staus.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetAllRequestsByStaus() throws GenisisServiceException {

		logger.info("**********Junit Test Get All Requests By Staus**********");
		List<Request> requests = requestService.getAllRequestsByStaus("ResultsNotAccepted");
		assertNotNull(requests);
	}

	/**
	 * Test get All Requests By Staus.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetAllRequestsByStaus_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get All Requests By Staus**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getAllRequestsByStaus("ResultsNotAccepted");
	}

	/**
	 * Test SubmitOrModify.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testSubmitOrModify() throws GenisisDAOException, GenisisServiceException {

		logger.info("**********Junit Test SubmitOrModify**********");
		request = requestDao.getRequestById(1);
		assertEquals(1, requestService.submitOrModify(request));
	}

	/**
	 * Test SubmitOrModify.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testSubmitOrModify_Null() throws GenisisServiceException {

		logger.info("**********Junit Test SubmitOrModify**********");
		requestService.submitOrModify(new Request());
	}

	/**
	 * Test SubmitOrModify RequestHistory.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void test1SubmitOrModifyRequestHistory() throws GenisisServiceException {

		logger.info("**********Junit Test SubmitOrModify RequestHistory**********");
		requestService.submitOrModify(new RequestHistory());
	}

	/**
	 * Test SubmitOrModify RequestHistory.
	 */
	@Test(expected = GenisisServiceException.class)
	public void test1SubmitOrModifyRequestHistory_null() throws GenisisServiceException {

		logger.info("**********Junit Test SubmitOrModify RequestHistory**********");
		setSessionFactory_Null();
		requestService_SF_NULL.submitOrModify(new RequestHistory());
	}

	/**
	 * Test SubmitOrModify RequestHistory.
	 */
	@Test
	public void testSubmitOrModifyRequestHistory() throws GenisisDAOException {

		/*
		 * logger.
		 * info("**********Junit Test SubmitOrModify RequestHistory**********");
		 * request = requestDao.getRequestById(1); List<RequestHistory>
		 * requestHistoryList =
		 * requestDao.getRequestHistoriesById(request.getId()); RequestHistory
		 * requestHistory = requestHistoryList.get(0);
		 * requestHistory.setRequest(request);
		 * assertNotNull(requestDao.submitOrModify(requestHistory));
		 */
	}

	/**
	 * Test get RequestHistory By Id.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestHistoryById() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistory By Id**********");
		List<RequestHistory> listOfRequestHistory = requestService.getRequestHistoriesById(1);
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test get RequestHistory By Id.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestHistoryById_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistory By Id**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestHistoriesById(1);
	}

	/**
	 * Test get RequestHistoryByRequestIdAndStatus.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestHistoryByRequestIdAndStatus() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistoryByRequestIdAndStatus**********");
		List<RequestHistory> listOfRequestHistory = requestService.getRequestHistoriesByRequestIdAndStatus(1, "Draft");
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test get RequestHistoryByRequestIdAndStatus.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestHistoryByRequestIdAndStatus_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistoryByRequestIdAndStatus**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestHistoriesByRequestIdAndStatus(1, "Draft");
	}
	
	/**
	 * Test getRequestHistoriesWithCommentsById.
	 */
	@Test
	public void testGetRequestHistoriesWithCommentsById() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistoriesWithCommentsById**********");
		List<RequestHistory> listOfRequestHistory = requestService.getRequestHistoriesWithCommentsById(1);
		assertNotNull(listOfRequestHistory);
	}

	/**
	 * Test getRequestHistoriesWithCommentsById.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestHistoriesWithCommentsById_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistoriesWithCommentsById**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestHistoriesWithCommentsById(1);
	}

	/**
	 * Test get RequestHistoryByRequestIdAndStatus.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestStatusCounts() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestHistoryByRequestIdAndStatus**********");
		List<WorkflowStatus> listOfWorkflowStatus = requestService.getRequestStatusCounts();
		assertNotNull(listOfWorkflowStatus);
	}

	/**
	 * Test getRequestStatusCounts.
	 */
	@Test(expected = GenisisServiceException.class)
	public void testGetRequestStatusCounts_null() throws GenisisServiceException {

		logger.info("**********Junit Test Get RequestStatusCounts**********");
		setSessionFactory_Null();
		requestService_SF_NULL.getRequestStatusCounts();
	}

	/**
	 * Test getWorkflowStatus.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetWorkflowStatus() throws GenisisServiceException {

		logger.info("**********Junit Test Get WorkflowStatus**********");
		WorkflowStatus workflowStatus = requestService.getWorkflowStatus(WorkflowStatusEnum.CANCELLED.getDesc());
		assertEquals("Cancelled", workflowStatus.getDescription());
	}

	/**
	 * Test getWorkflowStatus.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test(expected = GenisisServiceException.class)
	public void testtestGetWorkflowStatus_null() throws GenisisServiceException {

		logger.info("**********Junit Test SubmitOrModify RequestHistory**********");

		setSessionFactory_Null();
		requestService_SF_NULL.getWorkflowStatus(WorkflowStatusEnum.CANCELLED.getDesc());

	}

	private void setSessionFactory_Null() {

		requestService_SF_NULL = new RequestService();
		requestDao_SF_Null = new RequestDao();
		requestDao_SF_Null.setSessionFactory(null);
		requestService_SF_NULL.setRequestDao(requestDao_SF_Null);

	}

}